<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/includeBase.php";
    include "include/controlloLogin.php";
        
    $etichetta = isset($_GET["etichetta"]) ? filter_input(INPUT_GET,"etichetta",FILTER_SANITIZE_NUMBER_INT) : 0;
    $cerca     = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_STRING) : "";
    
    if($etichetta>0) {
        $parametriRicerca = [];
        $parametri = array("tabella"=>"geecD_documenti", "elementiPerPagina"=>50,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);        
    }
    else {
        $parametriRicerca = $cerca!="" ? ["nome"=>$cerca] : [];
        $parametri = array("tabella"=>"geecD_cartelle", "elementiPerPagina"=>50,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
    }
    
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"ricercaFileSystem.php");
    
    if($etichetta>0) {
        $ricerca->setQueryAnnidate(["id"=>" IN (SELECT idDocumento FROM geecD_associazioneEtichetteDocumenti WHERE idEtichetta=$etichetta)"]);
    }
    $ricerca->setOrdinamento("ORDER BY id ASC");
?>
<!doctype html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <?php
        include "include/cssBaseAreaAmministrativa.php";
    ?>
    <title>Geecom Doc - ricerca file system</title>

  </head>
  <body>
    
    <header>
        <?php 
            include "include/barraSuperiore.php";
            
            include "include/header.php";
            
            include "include/barraMenu.php";
        ?>
    </header>
	  
    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            <div class="row">
                <!-- Colonna principale -->
                <div class="col-12 py-4">

                    <div class="form-row">
                        <div class="col-12 file-manager">
                            <div class="card card-body border-0">
                                <div class="d-flex justify-content-between mb-3">
                                    <div></div>
                                    <?php 
                                        $ricerca->stampaFormRicerca($cerca);
                                    ?>
                                </div>
                                <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-lg-4 row-cols-xl-5" id="divContenutoCartella">
                                    <?php 
                                        if(isset($_GET["pag"])) {
                                            $risCartelle = $ricerca->eseguiRicerca($pagina);
                                        }
                                        else {
                                            $risCartelle = $ricerca->eseguiRicerca(1);
                                        }
                                        while($elemento = $risCartelle->fetch_assoc()) {
                                            if($etichetta==0) {
                                                stampaCartella($geecomDb, $elemento,false);
                                            }
                                            else {
                                                stampaDocumento($geecomDb,$elemento);
                                            }
                                        }

                                        if($etichetta==0) {
                                            $parametriRicercaFile = array("tabella"=>"geecD_documenti", "elementiPerPagina"=>50,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);

                                            $ricercaFile = new Ricerca($geecomDb, $parametriRicercaFile, $impostazioniRicerca,"ricercaFileSystem.php");
                                            $ricercaFile->setOrdinamento("ORDER BY id ASC");

                                            $risDocumenti = $ricercaFile->eseguiRicerca(1);
                                            while($documento = $risDocumenti->fetch_assoc()) {
                                                stampaDocumento($geecomDb,$documento);
                                            }
                                        }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /Colonna principale -->
            </div>
        </div>
    </main>

    <?php 
        include "include/footer.php";
        
        include "include/modal/cambiaPassword.php";
        
        include "include/modal/modalMenuComponenti.php";

        include "include/modal/operazioneCompletata.php";
        
        include "include/jsBaseAreaAmministrativa.php";
    ?>
        <script>
            function aggiornaElencoCartelle() {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerCartelle.php",
                    data:{
                        operazione:"stampaContenutoCartella",
                        id:<?php echo $cartella->getId() ?>
                    },
                    success:function(codice) {
                        document.getElementById("divContenutoCartella").innerHTML = codice;
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
        </script>
      
        <script type="text/javascript" src="../plugins/dropzone/dropzone.js"></script>
        <script>
            $(".singolo-file").dropzone({
                acceptedFiles: ".pdf,.doc,.docx,.odt,.odp,.ods,.jpeg,.jpg,.png,.gif,.svg,.zip",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    if(response=="ok") {
                        aggiornaElencoCartelle();
                        this.removeAllFiles();
                    }
                    else {
                        alert(response);
                    }
                },
                params:{
                    operazione:"crea",
                    idCartella:<?php echo $cartella->getId() ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            });  	
        </script>
    </body>
</html>
